# The knapsack problem is a problem in combinatorial optimization: Given a set of items, each with a weight and a value, determine the number of each item to include in a collection so that the total weight is less than or equal to a given limit and the total value is as large as possible.
# solvable in time O(nW)

class DP:
    def __init__(self, n:int, W:int):
        self._n = n
        self._W = W
        self._dp = [[0]*(W+1) for _ in range(n+1)]
    
    def knapsack(self, wv:list) -> list:
        for i in range(self._n):
            w, v = wv[i]
            for j in range(self._W+1):
                if j < w:
                    self._dp[i+1][j] = self._dp[i][j]
                else:
                    self._dp[i+1][j] = max(self._dp[i][j], self._dp[i][j-w]+v)
        return self._dp

n = 4         # Item conut
W = 8         # Limit sum wight
wv = [
    [3, 30],  # [wight, value]
    [4, 50],
    [5, 60],
    [6, 70]
]

d = DP(n,W)
result = d.knapsack(wv)
print(result[-1][-1])  # 90(Max value of combination under W) 


# DP table transition diagram
# ------------------------------
# [0, 0, 0, 0, 0, 0, 0, 0, 0]
# [0, 0, 0, 30, 0, 0, 0, 0, 0]
# [0, 0, 0, 0, 0, 0, 0, 0, 0]
# [0, 0, 0, 0, 0, 0, 0, 0, 0]
# [0, 0, 0, 0, 0, 0, 0, 0, 0]
# ------------------------------
# [0, 0, 0, 0, 0, 0, 0, 0, 0]
# [0, 0, 0, 30, 30, 0, 0, 0, 0]
# [0, 0, 0, 0, 0, 0, 0, 0, 0]
# [0, 0, 0, 0, 0, 0, 0, 0, 0]
# [0, 0, 0, 0, 0, 0, 0, 0, 0]
# ------------------------------
# [[0, 0, 0, 0, 0, 0, 0, 0, 0]
# [0, 0, 0, 30, 30, 30, 0, 0, 0]
# [0, 0, 0, 0, 0, 0, 0, 0, 0]
# [0, 0, 0, 0, 0, 0, 0, 0, 0]
# [0, 0, 0, 0, 0, 0, 0, 0, 0]
# ------------------------------
# [0, 0, 0, 0, 0, 0, 0, 0, 0]
# [0, 0, 0, 30, 30, 30, 30, 0, 0]
# [0, 0, 0, 0, 0, 0, 0, 0, 0]
# [0, 0, 0, 0, 0, 0, 0, 0, 0]
# [0, 0, 0, 0, 0, 0, 0, 0, 0]
# ------------------------------
# [0, 0, 0, 0, 0, 0, 0, 0, 0]
# [0, 0, 0, 30, 30, 30, 30, 30, 0]
# [0, 0, 0, 0, 0, 0, 0, 0, 0]
# [0, 0, 0, 0, 0, 0, 0, 0, 0]
# [0, 0, 0, 0, 0, 0, 0, 0, 0]
# [0, 0, 0, 0, 0, 0, 0, 0, 0]
# [0, 0, 0, 30, 30, 30, 30, 30, 30]
# [0, 0, 0, 0, 0, 0, 0, 0, 0]
# [0, 0, 0, 0, 0, 0, 0, 0, 0]
# [0, 0, 0, 0, 0, 0, 0, 0, 0]
# ------------------------------
# ------------------------------
# [0, 0, 0, 0, 0, 0, 0, 0, 0]
# [0, 0, 0, 30, 30, 30, 30, 30, 30]
# [0, 0, 0, 30, 0, 0, 0, 0, 0]
# [0, 0, 0, 0, 0, 0, 0, 0, 0]
# [0, 0, 0, 0, 0, 0, 0, 0, 0]
# ------------------------------
# [0, 0, 0, 0, 0, 0, 0, 0, 0]
# [0, 0, 0, 30, 30, 30, 30, 30, 30]
# [0, 0, 0, 30, 50, 0, 0, 0, 0]
# [0, 0, 0, 0, 0, 0, 0, 0, 0]
# [0, 0, 0, 0, 0, 0, 0, 0, 0]
# ------------------------------
# [0, 0, 0, 0, 0, 0, 0, 0, 0]
# [0, 0, 0, 30, 30, 30, 30, 30, 30]
# [0, 0, 0, 30, 50, 50, 0, 0, 0]
# [0, 0, 0, 0, 0, 0, 0, 0, 0]
# [0, 0, 0, 0, 0, 0, 0, 0, 0]
# ------------------------------
# [0, 0, 0, 0, 0, 0, 0, 0, 0]
# [0, 0, 0, 30, 30, 30, 30, 30, 30]
# [0, 0, 0, 30, 50, 50, 50, 0, 0]
# [0, 0, 0, 0, 0, 0, 0, 0, 0]
# [0, 0, 0, 0, 0, 0, 0, 0, 0]
# ------------------------------
# [0, 0, 0, 0, 0, 0, 0, 0, 0]
# [0, 0, 0, 30, 30, 30, 30, 30, 30]
# [0, 0, 0, 30, 50, 50, 50, 80, 0]
# [0, 0, 0, 0, 0, 0, 0, 0, 0]
# [0, 0, 0, 0, 0, 0, 0, 0, 0]
# ------------------------------
# [0, 0, 0, 0, 0, 0, 0, 0, 0]
# [0, 0, 0, 30, 30, 30, 30, 30, 30]
# [0, 0, 0, 30, 50, 50, 50, 80, 80]
# [0, 0, 0, 0, 0, 0, 0, 0, 0]
# [0, 0, 0, 0, 0, 0, 0, 0, 0]
# ------------------------------
# ------------------------------
# [0, 0, 0, 0, 0, 0, 0, 0, 0]
# [0, 0, 0, 30, 30, 30, 30, 30, 30]
# [0, 0, 0, 30, 50, 50, 50, 80, 80]
# [0, 0, 0, 30, 0, 0, 0, 0, 0]
# [0, 0, 0, 0, 0, 0, 0, 0, 0]
# ------------------------------
# [0, 0, 0, 0, 0, 0, 0, 0, 0]
# [0, 0, 0, 30, 30, 30, 30, 30, 30]
# [0, 0, 0, 30, 50, 50, 50, 80, 80]
# [0, 0, 0, 30, 50, 0, 0, 0, 0]
# [0, 0, 0, 0, 0, 0, 0, 0, 0]
# ------------------------------
# [0, 0, 0, 0, 0, 0, 0, 0, 0]
# [0, 0, 0, 30, 30, 30, 30, 30, 30]
# [0, 0, 0, 30, 50, 50, 50, 80, 80]
# [0, 0, 0, 30, 50, 60, 0, 0, 0]
# [0, 0, 0, 0, 0, 0, 0, 0, 0]
# ------------------------------
# [0, 0, 0, 0, 0, 0, 0, 0, 0]
# [0, 0, 0, 30, 30, 30, 30, 30, 30]
# [0, 0, 0, 30, 50, 50, 50, 80, 80]
# [0, 0, 0, 30, 50, 60, 60, 0, 0]
# [0, 0, 0, 0, 0, 0, 0, 0, 0]
# ------------------------------
# [0, 0, 0, 0, 0, 0, 0, 0, 0]
# [0, 0, 0, 30, 30, 30, 30, 30, 30]
# [0, 0, 0, 30, 50, 50, 50, 80, 80]
# [0, 0, 0, 30, 50, 60, 60, 80, 0]
# [0, 0, 0, 0, 0, 0, 0, 0, 0]
# ------------------------------
# [0, 0, 0, 0, 0, 0, 0, 0, 0]
# [0, 0, 0, 30, 30, 30, 30, 30, 30]
# [0, 0, 0, 30, 50, 50, 50, 80, 80]
# [0, 0, 0, 30, 50, 60, 60, 80, 90]
# [0, 0, 0, 0, 0, 0, 0, 0, 0]
# ------------------------------
# ------------------------------
# [0, 0, 0, 0, 0, 0, 0, 0, 0]
# [0, 0, 0, 30, 30, 30, 30, 30, 30]
# [0, 0, 0, 30, 50, 50, 50, 80, 80]
# [0, 0, 0, 30, 50, 60, 60, 80, 90]
# [0, 0, 0, 30, 0, 0, 0, 0, 0]
# ------------------------------
# [0, 0, 0, 0, 0, 0, 0, 0, 0]
# [0, 0, 0, 30, 30, 30, 30, 30, 30]
# [0, 0, 0, 30, 50, 50, 50, 80, 80]
# [0, 0, 0, 30, 50, 60, 60, 80, 90]
# [0, 0, 0, 30, 50, 0, 0, 0, 0]
# ------------------------------
# [0, 0, 0, 0, 0, 0, 0, 0, 0]
# [0, 0, 0, 30, 30, 30, 30, 30, 30]
# [0, 0, 0, 30, 50, 50, 50, 80, 80]
# [0, 0, 0, 30, 50, 60, 60, 80, 90]
# [0, 0, 0, 30, 50, 60, 0, 0, 0]
# ------------------------------
# [0, 0, 0, 0, 0, 0, 0, 0, 0]
# [0, 0, 0, 30, 30, 30, 30, 30, 30]
# [0, 0, 0, 30, 50, 50, 50, 80, 80]
# [0, 0, 0, 30, 50, 60, 60, 80, 90]
# [0, 0, 0, 30, 50, 60, 70, 0, 0]
# ------------------------------
# [0, 0, 0, 0, 0, 0, 0, 0, 0]
# [0, 0, 0, 30, 30, 30, 30, 30, 30]
# [0, 0, 0, 30, 50, 50, 50, 80, 80]
# [0, 0, 0, 30, 50, 60, 60, 80, 90]
# [0, 0, 0, 30, 50, 60, 70, 80, 0]
# ------------------------------
# [0, 0, 0, 0, 0, 0, 0, 0, 0]
# [0, 0, 0, 30, 30, 30, 30, 30, 30]
# [0, 0, 0, 30, 50, 50, 50, 80, 80]
# [0, 0, 0, 30, 50, 60, 60, 80, 90]
# [0, 0, 0, 30, 50, 60, 70, 80, 90]
# ------------------------------

